define([
		'app',
        'GraphService',
		'TrackersService',
        'TrackersConstants',
		'TrackersSummaryController',
		'TrackersEntryController',
        'RemindersService',
        'NotificationDeliveryDirective',
        'TrackerNavItemDateFilter',
        'TrackersNavController',
        'TrackersNotificationStatusController',
        'TrackersRemindersService',
        'TrackersRemindersInstanceService'
	],
	function (app) {
		"use strict";
		app.config(function ($stateProvider) {

			$stateProvider
				.state('main.auth.two-panel.secondary-navigation.trackers', {
					url: '/trackers',
					appNavIndex: 2,
					data: {
						moduleName: "Health",
						panel: "secondary",
                        baseStateName : 'main.auth.two-panel.secondary-navigation.trackers',
                        initialState : "summary",
                        paramSections : [
                            {
                                paramValue : "bp-pulse",
                                sectionName : "Blood Pressure and Pulse",
                                sectionIndex : 1,
                                iconClass : "icon-health-bloodpressure",
                                templateUrl : "src/modules/trackers/pages/nav/bp-pulse_item.html"
                            }, {
                                paramValue : "weight",
                                sectionName : "Weight",
                                sectionIndex : 2,
                                iconClass : "icon-health-weight",
                                templateUrl : "src/modules/trackers/pages/nav/weight_item.html"
                            }, {
                                paramValue : "glucose",
                                sectionName : "Glucose",
                                sectionIndex : 3,
                                iconClass : "icon-health-glucose",
                                templateUrl : "src/modules/trackers/pages/nav/glucose_item.html"
                            }, {
                                paramValue : "cholesterol",
                                sectionName : "Cholesterol",
                                sectionIndex : 4,
                                iconClass : "icon-health-cholesterol",
                                templateUrl : "src/modules/trackers/pages/nav/cholesterol_item.html"
                            }, {
                                paramValue : "mood",
                                sectionName : "Mood",
                                sectionIndex : 5,
                                iconClass : "icon-health-mood",
                                templateUrl : "src/modules/trackers/pages/nav/mood_item.html"
                            },
                             {
                                paramValue : "fitness-activity",
                                sectionName : "Fitness Activity",
                                sectionIndex : 6,
                                iconClass : "icon-learnmore-fitness",
                                templateUrl : "src/modules/trackers/pages/nav/fitness-activity_item.html"
                            }
                            ,
                            {
                                paramValue : "fitness-goals",
                                sectionName : "Fitness Goals",
                                sectionIndex : 7,
                                iconClass : "icon-learnmore-fitness",
                                templateUrl : "src/modules/trackers/pages/nav/fitness-goals_item.html"
                            }
                        ]
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/trackers/pages/trackers-placeholder_template.html',
                            controller: 'TrackersNavController'
						}
					}
				})
                .state('main.auth.two-panel.secondary-navigation.trackers.summary', {
                    url: '/{section:bp-pulse|weight|glucose|cholesterol|mood|fitness-activity|fitness-goals}/summary',
                    data: {
                        panel : "primary",
                        backState : "^"
                    },
                    views : {
                        'primary@main.auth.two-panel': {
                            templateUrl: 'src/modules/trackers/pages/summary/trackers-summary_template.html',
                            controller: 'TrackersSummaryController'
                        }
                    }
                })
                .state('main.auth.two-panel.secondary-navigation.trackers.entry', {
                    url: '/{section:bp-pulse|weight|glucose|cholesterol|mood|fitness-activity|fitness-goals}/entry?id',
                    data : {
                        panel : "primary",
                        backState : "^.summary"
                    },
                    views : {
                        'primary@main.auth.two-panel': {
                            templateUrl: 'src/modules/trackers/pages/entry/trackers-entry_template.html',
                            controller: 'TrackersEntryController'
                        }
                    }
                })
                .state('main.auth.two-panel.secondary-navigation.trackers.notification', {
                    url: '/{section:bp-pulse|weight|glucose|cholesterol|mood|fitness-activity|fitness-goals}/notification',
                    data: {
                        panel: 'primary',
                        backState: '^.summary'
                    },
                    views: {
                        'primary@main.auth.two-panel': {
                            templateUrl: 'src/modules/trackers/pages/notification-status/trackers-notification-status_template.html',
                            controller: 'TrackersNotificationStatusController'
                        }
                    }
                });
		});
	}


);
